function [yUMF,uUMF,yLMF,uLMF]=PR(inputFOU,antFOUs,conFOUs,nAlpha)
%
% [UMFy,UMFmu,LMFy,LMFmu]=PR(inputFOU,antFOUs,conFOUs,nAlpha)
%
% Perceptual Reasoning using similarity and LWA
%
% Dongrui Wu (dongruiw@usc.edu), 4/25/2009
%
% inputFOU: 9n*1 vector containing the input word FOUs, where n is the
% number of antecedents in the rules. Each FOU is represented by 9
% parameters.
% antFOUs: 9n*numRules matrix, where the i^th row stores the antecedent word
% FOUs for the i^th rule, and numRules is the number of rules.
% conFOUs: 9*numRules matrix storing the cosequent FOUs of the rules.
% nAlpha: numer of alpha-cuts. nAlpha>1. Default 2.
%
% yUMF: y-coordinates of the UMF of Y_PR
% uUMF: u-coordinates of the UMF of Y_PR
% yLMF: y-coordinates of the LMF of Y_PR
% uLMF: u-coordinates of the LMF of Y_PR

if nargin==3
    nAlpha=2;
elseif nargin==4
    nAlpha=max(2,round(nAlpha));
else
    error('The number of input parameters must be 3 or 4.');
end

%% number of antecedents
N=length(inputFOU)/9;
numRules=size(antFOUs,1);
fs=zeros(numRules,N);

for j=1:numRules
    for n=1:N
        fs(j,n)=Jaccard(inputFOU((n-1)*9+[1:9]),antFOUs(j,(n-1)*9+[1:9]));
    end
end
firingLevels=min(fs,[],2);

[yUMF,uUMF,yLMF,uLMF]=lwaPR(conFOUs,[firingLevels firingLevels],nAlpha);

